/**
 *
 * \file        hprfgw_manage.h
 *
 * \brief       RF management task/functions declarations and definitions
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        08/24/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFMANAGE_H_
	#define _HPRFGW_RFMANAGE_H_

#include "datatypes.h"
#include "network.h"
#include "hprfgw_rfPkt.h"
#include "hprfgw_rfRec.h"
#include "hprfgw_rftrans.h"

////////////////////////////////////////////////////////////////////////////////
//	Definitions
////////////////////////////////////////////////////////////////////////////////
#define		RF_NETWORK_MASTER_DEVICE							//	Define if compiling for network master device (gateway)	 
//#undef	RF_NETWORK_MASTER_DEVICE							//	Undefine if compiling for network slave device (eg. TPS6) 

#ifdef	RF_NETWORK_MASTER_DEVICE
	#define	DEFAULT_RF_NETWORK_SUPPORTED_DEVICES	16 
	#define	MAX_RF_NETWORK_SUPPORTED_DEVICES 		252
	#define	MAX_DESCRIPTIVE_TABLE_ENTRIES			256			//	Consists of entries for RF Devices, ASP packet and MLME packet
#else
	#define	DEFAULT_RF_NETWORK_SUPPORTED_DEVICES	1			
	#define	MAX_RF_NETWORK_SUPPORTED_DEVICES 		1			
	#define	MAX_DESCRIPTIVE_TABLE_ENTRIES			3			//	Consists of entries for gateway, ASP packet and MLME packet
	
	#define	GATEWAY_DESCRIPTIVE_TABLE_INDEX			0			
#endif

//	Possible RF Device link states
#define	RF_DEVICE_LINK_STATE_EMPTY					0
#define	RF_DEVICE_LINK_STATE_TEMP_CONN_ACCESS 		1
#define	RF_DEVICE_LINK_STATE_ACTIVE					2
#define	RF_DEVICE_LINK_STATE_FAIL					3
#define	RF_DEVICE_LINK_STATE_SLEEP					4
#define	RF_DEVICE_LINK_STATE_DISCONNECTED			5

#define	RF_DEVICE_MAX_PAYLOAD_SECURITY_DISABLED		100
#define	RF_DEVICE_MAX_PAYLOAD_SECURITY_ENABLED		80
#define	RF_DEVICE_TRANSMIT_BUFFER_SIZE				(RF_DEVICE_MAX_PAYLOAD_SECURITY_DISABLED-sizeof(TYPE_RF_PAYLOAD_HEADER))	
#define	RF_DEVICE_DATA_HOLD_BUFFER_SIZE				(CNET_MAX_MSG_SIZE+sizeof(TYPE_RF_DEVICE_RFTX_INTERNAL_HDR))


#define	RF_DEVICE_LINK_QUALITY_HYSTERISES			655		//	rf device link quality hysterisas threshold

////////////////////////////////////uid////////////////////////////////////////////
//	Variable prototypes 
////////////////////////////////////////////////////////////////////////////////

typedef	struct	{
	UINT8	uid[UID_MAX_SIZE]; 					//	remote device unique identifier
	UINT16	panid;								//	remote device panid 
	UINT8	addrmode;							//	remote device addressing mode (16-bit, 64-bit)
	UINT8	rfid;								//	remote device rfid used in cresnet frames
	UINT32	tsid;								//	
	UINT8	power;								//	remote device rf power level 
	INT8	idstring[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN+1];//	device id string 	
	UINT16	deviceoptions;						//	remote device option flags ((AC/battery operated, traffic type etc..) 
}	TYPE_RF_DEVICE_ID_INFO;			

#define	RF_DEVICE_MAX_MSG_ERRORS	100
typedef	struct	{
	UINT8	type;								//	MCP, ASP, MLME
	UINT8	initiator;							//	MSG_Send, MSG Confirm, etc...
	UINT8	code;								//	Error Status code
}	TYPE_RF_DEVICE_ERR;				
typedef	struct	{
	TYPE_RF_DEVICE_ERR Err[RF_DEVICE_MAX_MSG_ERRORS];
	UINT16	in;
	UINT16	out;	
}	TYPE_RF_DEVICE_MSG_ERR;				

typedef	struct	{
	BOOL	txbufoverflowflag;					//	transmit buffer overflow occured if set	 			
	UINT32	txbufoverflowcount;					//	number of times the transmiter buffer overflow occured  
											
	BOOL	rxbufoverflowflag;					//	receiver buffer overflow occured if set 
	UINT32	rxbufoverflowcount;					//	number of times the receiver buffer overflow occured

	UINT32	txpacketcount;						//	total number of transmitted packets to RF Device
	UINT32	rxpacketcount;						//	total number of received packets from RF Device
	UINT32	txpacketfailcount;					//	total number of packets that could not be sent to the RF Device

	UINT32	rxpacketrepeatcount;				//	total number of repeat packets received from the Rf Device
	UINT32	rxpacketsequenceErrcount;			//	rf device frame sequence error count
	
	UINT32	txpacketfailsincelastactivelinkcnt;	//		

	UINT32	rxpacketsegmentationerrcnt;			//	total number of errors in received packet segments

	TYPE_RF_DEVICE_MSG_ERR	MsgErr;				//	rf stack msg send, msg confirmation errors

}	TYPE_RF_DEVICE_COM_LOG;				


//	RF Device internal header, set when posting a packet to the rf transmit task 
typedef	struct	{
	UINT8	type;								//	primary type 	
	UINT8	subtype;							//	sub-type	
	UINT8	hdroptions1;						//	frame transmit options (ack, noack, broadcast, unicast, priority etc...)
	UINT8	hdroptions2; 						//	unused	
	UINT8	hdroptions3; 						//	unused
}	TYPE_RF_DEVICE_RFTX_INTERNAL_HDR;

typedef	struct	{
	TYPE_RF_DEVICE_RFTX_INTERNAL_HDR inthdr;	//	Internal RF packet header	  	
	UINT8	data[RF_DEVICE_DATA_HOLD_BUFFER_SIZE];
	UINT32	len;								//	data hold buffer length
	UINT16	index;								//	index into the data hold buffer
	UINT8	totalsegment;						//	total segments of the data hold buffer 
	UINT8	segmentno;  						//	segment number of the data hold buffer	
}	TYPE_RF_DEVICE_RF_DATA_HOLD_BUF;

typedef	struct	{
	TYPE_RF_PAYLOAD_HEADER hdr;  			//	transmit payload header	(there is a single header per payload)
	UINT8	data[RF_DEVICE_TRANSMIT_BUFFER_SIZE];//	transmit payload data buffer			
}	TYPE_RF_TRANSMIT_PAYLOAD_BUF;

typedef	struct	{
	TYPE_RF_DEVICE_RFTX_INTERNAL_HDR inthdr;	//	Internal header 	
	TYPE_RF_TRANSMIT_PAYLOAD_BUF payld;			//	RF transmit payload buffer		 
	UINT8	len;								//	transmit payload data buffer length
	UINT8	index;								//	index into the transmit payload data buffer
}	TYPE_RF_DEVICE_RF_TRANSMIT_BUF;

typedef	struct	{
	TYPE_RF_DEVICE_RF_TRANSMIT_BUF	Transmit;
	TYPE_RF_DEVICE_RF_DATA_HOLD_BUF	DataHold;
}	TYPE_RF_DEVICE_RFTX_BUF;
   
typedef	struct	{
	TYPE_RF_PAYLOAD_HEADER payldhdr; 			//	receive payload header
	TYPE_RF_PACKET_HEADER  pkthdr;				//	receive packet header	
	UINT8	data[RF_DEVICE_DATA_HOLD_BUFFER_SIZE]; //	packet data 
	
	UINT16	index;								//	index into the data hold buffer
	UINT8	segmenterror;						//	error occured during packet de-segmentation
}	TYPE_RF_DEVICE_RFRX_BUF;

typedef	struct	{
	UINT8	linkqualityAtGatewayReported; 		//	link quality reported value to CS
	UINT8	linkqualityAtDeviceReported;		//	link quality reported value to CS	
}	TYPE_RF_DEVICE_LINKQUALITY_REPORTED;		//
TYPE_RF_DEVICE_LINKQUALITY_REPORTED LQRPTR[MAX_DESCRIPTIVE_TABLE_ENTRIES];		

typedef	struct	{
	TYPE_RF_DEVICE_ID_INFO	IDInfo;		//	rf device id information
		
	UINT8	linkstate;					//	current link state (not connected, active, partial, fail, sleep)
	UINT32	linkstatecnt;				//	counts number of link state changes from active state to partial state
	
	UINT32	linkeactiveestablishedtime; //	time when active link was established (derived from real time clock)
	INT16	linkeactiveestablishedday;		 
	INT16	linkeactiveestablishedmonth;	 
	INT16	linkeactiveestablishedyear;	

	UINT8	linkqualityAtgateway;		//	link quality level at gateway measured with last device packet
	UINT8	linkqualityAtDevice;		//	link quality level at device measured on the device side on gateway packets

	UINT8	txsequence;					//	transmitting frame sequence count
	UINT8	rxsequence;					//	receiving frame sequence count
	UINT16	txpacketretry;				//	transmit packet retry count, reset after successful transmission
	
	TYPE_RF_DEVICE_COM_LOG  COMLog;		//	communication log parameters

	NU_PIPE pipe;						//	pipe control block
	UINT8	*ppipebuf;					//	pointer to pipe memory block	

	TYPE_RF_DEVICE_RFTX_BUF	TxBuf;		//	transmit data buffer 
	
	
	UINT8	waitingforACK; 				//	device is waiting for ACK/NAK etc if set  	
	UINT8	resultcodeavailable; 		//	device's result code is avaliable if set 	
	UINT8	resultcode;					//	device's result code
	
	UINT16	RetryTimer;					//
	UINT8	RetryTimedOut;				//
	
	UINT16	HeartBeatTimer;				//
	UINT8	HeartBeatTimedOut;			//
	
    UINT16	ResultCodeTimer;			//
	UINT8	ResultCodeTimedOut;			//
	
	TYPE_RF_DEVICE_RFRX_BUF	RxBuf;		//	receiver data buffer	
	
}	TYPE_RF_DESCRIPTIVE_TABLE;
extern TYPE_RF_DESCRIPTIVE_TABLE* g_pRFDeviceDescriptiveTable;
extern UINT8  g_MaxSupportedRFDevices;
extern UINT8  g_MaxDescriptiveTableEntries;	

////////////////////////////////////////////////////////////////////////////////
//	Function declaractions	
////////////////////////////////////////////////////////////////////////////////
void    RFManage_Init (void);
UINT16 	RFManage_GetRFDeviceTableIndexByRFID (UINT8 RFID, UINT8 *pIndex);
UINT16	RFManage_GetDesTableIndexByUID (UINT8 *pUID, UINT16 *pTableIndex);

UINT16 	RFManage_UpdateLinkQualityAtGateway (UINT8 index, UINT8 linkquality);
UINT16 	RFManage_UpdateLinkQualityAtDevice (UINT8 index, UINT8 linkquality);

UINT8 	RFManage_GetRFDeviceLinkState (UINT8 index);
UINT16 	RFManage_SetRFDeviceLinkStateToActive (UINT8 index);
UINT16 	RFManage_IncrmentRFDeviceLinkStateCount (UINT8 index);

UINT16 	RFManage_RFDeviceRepeatFrameError (UINT8 index);

UINT8 	RFManage_GetRFDeviceReceiverSequenceCount (UINT8 index);	
UINT16 	RFManage_IncrementRFDeviceReceiverSequenceCount (UINT8 index);
UINT16 	RFManage_SyncRFDeviceReceiverSequenceCount(UINT8 index, UINT8 sequencecnt);
UINT16	RFManage_RFDeviceSequenceCountError (UINT8 index);		

UINT16 	RFManage_IncrementRFDeviceTotalRxFrameCount (UINT8 index);

UINT16 	RFManage_GetRFDeviceTxBufOverFlowParameters (UINT8 index, UINT8 *pTxOVFflg, UINT32 *pTotalTxOVFCntr);			
UINT16 	RFManage_GetRFDeviceRxBufOverFlowParameters (UINT8 index, UINT8 *pRxOVFflg, UINT32 *pTotalRxOVFCntr);

UINT16 	RFManage_ClearRFDeviceTxBufOverFlowParameters (UINT8 index);			
UINT16 	RFManage_ClearRFDeviceRxBufOverFlowParameters (UINT8 index);	
UINT16 	RFManage_GetRFDevicetotaltxframefailsincelastactivelinkcnt (UINT8 index);
UINT16 	RFManage_ClearRFDevicetotaltxframefailsincelastactivelinkcnt (UINT8 index);
 
UINT16 RFManage_GetRFDeviceMCPMsgPostError (UINT8 index, UINT8 *perr);
UINT16 RFManage_PutRFDeviceMCPMsgPostError (UINT8 index, UINT8 err);
UINT16 RFManage_GetRFDeviceMCPMsgConfirmError (UINT8 index, UINT8 *perr);
UINT16 RFManage_PutRFDeviceMCPMsgConfirmError (UINT8 index, UINT8 err);

UINT8 	RFManage_GetMLMEDescriptiveTableIndex (void);
UINT8 	RFManage_GetASPDescriptiveTableIndex (void);

UINT16	RFManager_IsDuplicateUID(UINT8 index, UINT32 tsid);

void	RFManage_LinkStateTransition (UINT8 index, UINT8 LinkState);
BOOL	RFManage_IsLocalDeviceInAcquire (void);
void	RFManage_UpdateDeviceIDInfo(UINT8 index, TYPE_RF_LINK_REQUEST_PACKET_DATA *pdata, UINT8 idstrlen);	
UINT16  RFManage_CreateEntryInDescriptiveTable (UINT8 *pdsindex, UINT8 *puid, UINT16 panid, UINT8 addrmode, UINT8 rxsequence);
UINT16	RFManage_GetIndexToDescriptiveTableByUID (UINT8 *pdsindex, UINT8 *pUID);
void	RFManage_BuildRFDeviceTableIndexByRFID (void);

void	RFManage_SetUID (UINT8 index, UINT8 *puid);
void	RFManage_SetPanID (UINT8 index, UINT16 PanID);		


#endif
/**/
